<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akcwg="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/AKC_WG.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/AKC_WG.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v8_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="utf-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_AKCWG" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_AKCWG"> <xsl:for-each select=" ns1:Header |  ns4:* | akcwg:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="Wyroby" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:apply-templates mode="KwotaPodatku" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" colspan="2" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b>podatnika<sup>1)</sup> </b> </span> </td> <td align="center" colspan="2" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" colspan="1" valign="top"> <td align="left" height="45" valign="top" width="353"/> <td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"> <b>2. Nr dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"> <b>3. Status</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">AKC-WG</span> </td> </tr> <tr> <!--<td height="61" width="154"/> --> <td> <div align="left"> <span class="nag1">DEKLARACJA W SPRAWIE PODATKU AKCYZOWEGO OD NABYCIA WEWNĄTRZWSPÓLNOTOWEGO WYROBÓW GAZOWYCH</span> <br/> <span class="nag1">(z wyłączeniem gazu do napędu silników spalinowych)<br/>za </span> </div> </td> <!--<td width="243"/>--> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | akcwg:*"> <table> <tr> <td height="49" width="135"> <b>4. Miesiąc </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="135"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <!--<td align="left" valign="top" width="131">  </td> <td width="206"/> --> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 24b ust. 1 pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.), zwanej dalej „ustawą”.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top">Do 25. dnia miesiąca następującego po miesiącu, w którym upłynął termin płatności wynikający z faktury, a jeżeli termin ten nie został określony – po miesiącu, w którym wystawiono fakturę.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu podatkiem akcyzowym; jeżeli czynności podlegające opodatkowaniu są wykonywane lub stany faktyczne podlegające opodatkowaniu występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4–4f ustawy; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="4"> <span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="4"> <b>6.Naczelnik urzędu skarbowego</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOfficeName"/> </span> </td> </tr> <tr> <td class="style3"> <b>7. Cel złożenia formularza</b>(zaznaczyć własciwy kwadrat):  <br/> <br/> <p> <span class="cz14"> <xsl:choose> <xsl:when test="//@submissionAim='Deklaracja'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> 1. złożenie deklaracji <span class="cz14"> <xsl:choose> <xsl:when test="//@submissionAim='Korekta'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span>  2. korekta deklaracji<sup style="cz9">2)</sup> </p> </td> <td class="style3" colspan="3"> <b>8. Korekta deklaracji – informacje dodatkowe</b> <sup>3)</sup> <br/> <br/> <p> <span class="cz14"> <xsl:choose> <xsl:when test="//@applicationForOverpayment='true'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span>   wniosek o stwierdzenie nadpłaty powstałej w wyniku korekty deklaracji	</p> </td> </tr> <td colspan="4"> <b>9. Uzasadnienie wniosku o stwierdzenie nadpłaty, wraz z podaniem kwoty żądanej nadpłaty</b> (wypełnić w przypadku zaznaczenia kwadratu w poz. 8) <br/> <span class="cz18"> <xsl:value-of select="@justification"/> <span class="cz18"> <br/> <xsl:value-of select="@overpaymentAmount"/> </span> </span> </td> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE PODATNIKA</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>10. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td> </tr> <tr> <td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='N'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='F'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>11. Nazwa pełna<sup>4)</sup>/Nazwisko, pierwsze imię<sup>5)</sup> </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//tr:PrivatePerson/tr:BasicData/@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//tr:PrivatePerson/tr:BasicData/@firstName"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY<sup>4)</sup>/ ADRES ZAMIESZKANIA<sup>5)</sup> </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>12. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>13. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>14. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>15. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>16. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>17. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>18. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="4"> <b>19. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td> <b>20. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">AKC-WG</span> <sub style="cz9">(6)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | akcwg:*" mode="Wyroby"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> <!-- TABELKA DLA J --> <table border="1" width="955"> <!-- NAGLOWEK --> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="8">C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW</td> </tr> <!-- I-OPIS --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td width="20"> Lp. </td> <td width="301">Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatku</td> <td width="100"> <p align="center">Ośmiocyfrowy kod CN </p> </td> <td colspan="2"> <p align="center">Ilość wyrobów w tysiącach kilogramów lub w GJ wynikająca z wartości opałowej<sup>6)</sup> <br/>  (z dokładnością do trzech miejsc po przecinku) </p> </td> <td width="80">Stawka podatku </td> <td width="153"> <p align="center">Podatek akcyzowy<sup>7)</sup> </p> </td> <td>Zwolnienie od podatku akcyzowego<br/> (zaznaczyć właściwy kwadrat)  </td> </tr> <!-- II-WIERSZ - OZNACZENIE --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td> <div align="center"> <b>a</b> </div> </td> <td> <div align="center"> <b>b</b> </div> </td> <td> <div align="center"> <b>c</b> </div> </td> <td> <div align="center"> <b>d</b> </div> </td> <td> <div align="center"> <b>e</b> </div> </td> <td> <div align="center"> <b>f</b> </div> </td> <td> <div align="center"> <b>g</b> </div> </td> <td> <div align="center"> <b>h</b> </div> </td> </tr> <!-- III - WARTOSCI --> <xsl:for-each select="//ns1:Item | //akcwg:Item"> <tr align="left" valign="top"> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@id"/> </div> </td> <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@groupOfGoodsName"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoodsK"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoodsJ"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@taxRate"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <!-- <xsl:value-of select="@exemptionFromExciseDuty"/> --> <xsl:choose> <xsl:when test="@exemptionFromExciseDuty='false'"> nie </xsl:when> <xsl:otherwise> tak </xsl:otherwise> </xsl:choose> </div> </td> </tr> </xsl:for-each> <!-- PODSUMOWANIE TABELKI --> <xsl:for-each select="."> <!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> --> <tr> <td>-</td> <td bgcolor="#CCCCCC" colspan="2"> <b>Razem </b> </td> <!--	<td bgcolor="#CCCCCC">-</td> --> <td> <b>154.</b> <div align="right" class="cz18" valign="top"> <b> <xsl:value-of select="//@totalNumberOfGoodsK"/> </b> </div> </td> <td> <b>155.</b> <div align="right" class="cz18" valign="top"> <b> <xsl:value-of select="//@totalNumberOfGoodsJ"/> </b> </div> </td> <td bgcolor="#CCCCCC">-</td> <td> <b>156.</b> <div align="right" class="cz18" valign="top"> <b> <xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/> </b> </div> </td> <td bgcolor="#CCCCCC">-</td> </tr> </xsl:for-each> </table> <!-- STOPKA --> <!-- KONIEC TABELKI ZAL_C --> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:template match="ns1:Header | akcwg:*" mode="KwotaPodatku"> <!--<table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="4"> <b>D. WYSOKOŚĆ PODATKU AKCYZOWEGO </b> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"> <p/> <p/> <p/> <p/> </td> <td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"> <b>Razem obliczony podatek  </b> <br/> <p> Kwota z poz. 274</p> </td> <td align="left" colspan="2" valign="top" width="283"> <b>275.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" height="46" valign="top"> <b>Zwolnienia i obniżenia </b> <br/> <p>Wykazana kwota nie może przekroczyć kwoty z poz. 275</p> </td> <td align="left" colspan="2" valign="top"> <b>276.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@reductions),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> <tr> <td bgcolor="#CCCCCC"> <b>Podatek akcyzowy do zapłaty<sup>***)</sup> </b> <br/> <p>Od kwoty z poz.275 należy odjąć kwotę wykazaną w poz. 276.</p> </td> <td align="left" colspan="2" valign="top"> <b>277.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalOfTax),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> </table> --> <!-- NOWA TABELKA --> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="3"> D. WYSOKOŚĆ PODATKU AKCYZOWEGO</td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="9" width="40"/> <td align="left" bgcolor="#CCCCCC" valign="top" width="546"> <b>Razem obliczony podatek akcyzowy</b> <br/> Kwota z poz. 156</td> <td align="left" valign="top" width="347"> <b>157. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>Zwolnienia</b> <br/>Suma kwot z poz. 159-162 </td> <td align="left" valign="top"> <b>158. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@exemption),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>     zwolnienie od podatku akcyzowego wyrobów gazowych<br/>      na podstawie art. 31b ust. 1 pkt 3 ustawy</b> <sup>8)</sup> </td> <td align="left" valign="top"> <b>159. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@exemptionFromExciseDutyOnGas3),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>     zwolnienie od podatku akcyzowego wyrobów gazowych <br/>      na podstawie art. 31b ust. 1 pkt 3a ustawy</b> <sup>8)</sup> </td> <td align="left" valign="top"> <b>160. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@exemptionFromExciseDutyOnGas3a),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>     zwolnienie od podatku akcyzowego wyrobów gazowych<br/>      na podstawie art. 31b ust. 1 pkt 3b ustawy</b> <sup>8)</sup> </td> <td align="left" valign="top"> <b>161. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@exemptionFromExciseDutyOnGas3b),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>     pozostałe zwolnienia od podatku akcyzowego wyrobów gazowych</b> </td> <td align="left" valign="top"> <b>162. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@exemptionOther),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>Obniżenia</b> <br/> </td> <td align="left" valign="top"> <b>163. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@reductions),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>Razem zwolnienia i obniżenia </b> <br/> Suma kwot z poz. 158 i 163 nie może przekroczyć kwoty z poz. 157. </td> <td align="left" valign="top"> <b>164. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalExemptionOfReductions),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" valign="top"> <b>Podatek akcyzowy do zapłaty </b> <sup>7)</sup> <br/> Od kwoty z poz. 157 należy odjąć kwotę wykazaną w poz. 164. </td> <td align="left" valign="top"> <b>165. </b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalOfTax),'# ##0')"/> <span align="right" class="cz9" valign="bottom">zł</span> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | akcwg:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> <!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.--> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="40"/> <td height="37" width="402"> <b>166. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>167. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="2"> <b>168. Podpis podatnika lub osoby reprezentującej podatnika </b> <span class="cz18"> <br/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <xsl:choose> <xsl:when test="string-length(//@repIdentifier)='11'"> <b>169. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> <sup>1)</sup> </xsl:when> <xsl:otherwise> <b>169. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby składającej podpis</b> <sup>1)</sup> </xsl:otherwise> </xsl:choose> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repIdentifier"/> </span> </td> <td> <b>170. Data wypełnienia deklaracji</b> (dzień – miesiąc – rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="3"> <b>128. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b> (pozycja nieobowiązkowa) <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@phone"/> </span> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | akcwg:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3" height="36"> <span class="nag1">E. ADNOTACJE URZĘDU SKARBOWEGO<sup>9)</sup> </span> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>172. Uwagi urzędu skarbowego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>173. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>174. Podpis przyjmującego formularz </b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | akcwg:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia</b> <b/> </p> <p> <sup>1)</sup>  Numer PESEL należy podać w przypadku osób fizycznych niebędących zarejestrowanymi podatnikami podatku od towarów i  usług       lub nieprowadzących działalności gospodarczej.<br/> <sup>2)</sup> Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2021 r. poz. 1540, z późn. zm.). <br/> <sup>3)</sup> Zaznaczyć w przypadku gdy podatnik razem z korektą deklaracji wnioskuje o stwierdzenie nadpłaty powstałej w jej wyniku zgodnie z art. 75 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa. <br/> <sup>4)</sup> Dotyczy podatników niebędących osobami fizycznymi.<br/> <sup>5)</sup> Dotyczy podatników będących osobami fizycznymi. <br/> <sup>6)</sup> Jeżeli stawka podatku akcyzowego została określona w zł/1000 kilogramów, należy wypełnić pola w kolumnie „d”, natomiast jeżeli stawka podatku akcyzowego została określona w zł/GJ, należy wypełnić pola w kolumnie „e”. <br/> <sup>7)</sup> Kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.<br/> <sup>8)</sup> Do możliwości stosowania zwolnienia mają zastosowanie warunki określone w art. 163c ustawy. <br/> <sup>9)</sup> Część F nie jest wypełniana w przypadku otrzymania przez urząd skarbowy dokumentu w postaci elektronicznej. </p> <p align="center"> <b> Pouczenia </b> </p> <p>W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 165 lub wpłacenia go w niepełnej wysokości niniejsza deklaracja stanowi podstawę do  wystawienia  tytułu  wykonawczego  zgodnie  z przepisami ustawy z dnia  17  czerwca  1966 r. o postępowaniu  egzekucyjnym w administracji (Dz. U. z 2020 r. poz. 1427, z późn. zm.). </p> <p>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym. </p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">AKC-WG</span> <sub style="cz9">(6)</sub> <b style="nag1">/2</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>